﻿namespace Code6587EN.Ch01.CreateComposedLook
{
    using Microsoft.SharePoint;
    using System;

    /// <summary>
    /// Console Application to create a new Composed Look
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the SharePoint Site Collection containing the SharePoint Site in a Using statement
            using (var site = new SPSite("http://sharepoint/site"))
            {
                // Open the SharePoint Site in a Using statement
                using (var web = site.OpenWeb())
                {
                    // Get the Composed Looks list
                    var list = web.Lists["Composed Looks"];

                    // Add a new item
                    var item = list.Items.Add();

                    // Set the item properties
                    item["Title"] = "Code";
                    item["Name"] = "Code";
                    item["Master Page URL"] = "/_catalogs/masterpages/seattle.master";
                    item["Theme URL"] = "/_catalogs/theme/15/palette005.spcolor";
                    item["Image URL"] = "/_layouts/15/images/image_bg005.jpg";
                    item["Font Scheme URL"] = "/_catalogs/theme/15/fontscheme003.spfont";
                    item["Display Order"] = "200";

                    // Update the item
                    item.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
